import UIKit

extension ViewController
{
    func flip(inpTile: MyTile,
              animOpt: UIView.AnimationOptions,
              bgColor: UIColor,
              inpTxt: String,
              inpImg: UIImage,
              compare: Bool)
    {
        UIView.transition(with: inpTile,
                          duration: 0.5,
                          options: animOpt,
                          animations:
            {
                inpTile.backgroundColor = bgColor
                inpTile.lbl.text = inpTxt
                inpTile.imgViw.image = inpImg
        }) { (res) in
            self.aTileIsAnimating = false
            if ( compare)
            {
                self.compare()
            }
        }
    }
}
